;;  $Id: crt0.S,v 1.1 2002/09/20 16:05:44 michaels Exp $
;;  
;;  startup file GNU compiler,
;;  Motorola PXE Processor.
;;
;;  Michael Staudenmaier
;;
;;  $Revision: 1.1 $  
;;  $Date: 2002/09/20 16:05:44 $
;;
;;  Motorola Confidential Proprietary
;;
	
	.section .text

	.global  _start
_start:
	
	;; initialize stack and frame pointer
	;; mov	__stack, a7
	;; adh	__stack, a7
	;; mov	a7, a6

	;; initialize hardware
	mov	_hardware_init_hook, a0
	adh	_hardware_init_hook, a0
	cmp	0, a0
	bseq	.Lno_hardware_init
	jsr	(a0)
.Lno_hardware_init:
	
	;; zero the data space
	mov	_clear_start, a4
	adh	_clear_start, a4
	mov	_clear_end, d0
	adh	_clear_end, d0
	sub	a4, d0, d1

	extu	27,5,d1,d2	; calc. number of blocks (32bytes)
	mvc7	0, d0
	dseq	.L1
	mtsr	d2, LCT0

.L0:	stw	d0, (a4)+
	stw	d0, (a4)+
	stw	d0, (a4)+
	stw	d0, (a4)+
	stw	d0, (a4)+
	stw	d0, (a4)+
	stw	d0, (a4)+
	dsl0	.L0
	stw	d0, (a4)+
.L1:
	extu	3,2,d1,d2	; calc the number of missing words
	mtsr	d2, LCT0
	bseq	.L3

.L2:	dsl0	.L2
	stw	d0, (a4)+
.L3:
.LNoClear:
	;; call global and static constructors
	mov	_init, a5
	adh	_init, a5
	jsr	(a5)

	;; setup destructors to be called from exit
	;; (just in case main never returns
	mov	_fini, d0
	adh	_fini, d0
	mov	_atexit, a5
	adh	_atexit, a5
	jsr	(a5)

	;; initialize argc, argv, and envp to empty
	mvc7	0, d0
	mvc7	0, d1
	mvc7	0, d2

	;; call main
	mov	_main, a5
	adh	_main, a5
	jsr	(a5)

	;; if there is no explicit call to exit/abort assume there was no error
	mvc7	0,D0		; needed for automatic test environment

	;; jump to exit
	mov	_exit, a5
	adh	_exit, a5
	jsr	(a5)

	;; unreachable
.L4:	bsal	.L4
